#include <bits/stdc++.h>
using namespace std;

int main() {
    int N, K;
    cin >> N >> K;

    vector<int> storeLocations(K);
    for (int i = 0; i < K; ++i) {
        cin >> storeLocations[i];
    }

    vector<int> population(N);
    long long totalPopulation = 0;
    for (int i = 0; i < N; ++i) {
        cin >> population[i];
        totalPopulation += population[i];
    }

    long long neededCustomers = totalPopulation / 2 + 1;

    vector<pair<long long, int>> cityDistances(N);

    for (int i = 0; i < N; ++i) {
        cityDistances[i] = {0, i};
    }

    long long coveredCustomers = 0;
    for (int location : storeLocations) {
        coveredCustomers += population[location - 1];
    }
    if (coveredCustomers >= neededCustomers) {
        cout << "0" << endl;
        return 0;
    }

    sort(cityDistances.begin(), cityDistances.end(), [&](const pair<long long, int>& a, const pair<long long, int>& b) {
        return population[a.second] > population[b.second];
    });

    long long currentCustomers = coveredCustomers;
    int additionalStores = 0;

    for (auto &[dist, cityIndex] : cityDistances) {
        if (currentCustomers >= neededCustomers) break;
        auto it = find(storeLocations.begin(), storeLocations.end(), cityIndex + 1);
        if (it == storeLocations.end()) { 
            currentCustomers += population[cityIndex];
            additionalStores++;
        }
    }

    cout << additionalStores << endl;

    return 0;
}